﻿using System.Xml;

namespace XAdES_BES
{
    public class XmlHelper
    {
        public static XmlElement FindNodeWithAttributeValueIn(XmlNodeList data, string attrName, string attrValue)
        {
            if (data?.Count > 0)
            {
                foreach(XmlNode node in data)
                {
                    var element = node as XmlElement;
                    if (element != null)
                    {
                        if (attrValue.Equals(element.GetAttribute(attrName)))
                        {
                            return element;
                        }
                    }

                    element = FindNodeWithAttributeValueIn(node.ChildNodes, attrName, attrValue);
                    if (element != null) return element;
                }
            }

            return null;
        }
    }
}
