﻿using System;
using System.Collections.Generic;
using CSSZSubmissionDemo.Configuration;

namespace CSSZSubmissionDemo.Submissions
{
    abstract class MessageBase
    {
        protected byte[] content;
        protected Configuration.SubmissionElement info;
        protected Configuration.CertificateElement signerCert;
        protected Configuration.CertificateElement recipientCert;
        protected Guid internalID = Guid.NewGuid();

        public KeyValuePair<string, string> ID
        {
            get;
            protected set;
        }

        public string InternalID { get { return internalID.ToString("N"); } }
        public string ClassName { get { return info.ClassName; } }
        public string DisplayName { get { return InternalDisplayName(); } }

        public void Initialize(ref byte[] content, KeyValuePair<string, string> id, SubmissionElement info, Configuration.CertificateElement signerCert, Configuration.CertificateElement recipientCert)
        {
            this.ID = id;
            this.content = content;
            this.info = info;
            this.signerCert = signerCert;
            this.recipientCert = recipientCert;
        }

        protected abstract string InternalDisplayName();
    }
}
