﻿using System.Configuration;

namespace CSSZSubmissionDemo.Configuration
{
    public class SubmissionElement : CustomConfigurationElementBase
    {
        public override string DisplayName
        {
            get { return string.Format("{0}-{1} ({3}:{2})", ClassName, eType, XMLRoolElement, XMLNamespace); }
        }

        [ConfigurationProperty("XMLRoolElement", IsRequired = true, IsKey = false)]
        public string XMLRoolElement
        {
            get { return (string)this["XMLRoolElement"]; }
            set { this["XMLRoolElement"] = value; }
        }

        [ConfigurationProperty("XMLNamespace", IsRequired = true, IsKey = true)]
        public string XMLNamespace
        {
            get { return (string)this["XMLNamespace"]; }
            set { this["XMLNamespace"] = value; }
        }

        [ConfigurationProperty("ClassName", IsRequired = true, IsKey = true)]
        public string ClassName
        {
            get { return (string)this["ClassName"]; }
            set { this["ClassName"] = value; }
        }

        [ConfigurationProperty("eType", IsRequired = true, IsKey = true)]
        public string eType
        {
            get { return (string)this["eType"]; }
            set { this["eType"] = value; }
        }

        [ConfigurationProperty("VS8", IsRequired = true, IsKey = true)]
        public bool VS8
        {
            get { return (bool)this["VS8"]; }
            set { this["VS8"] = value; }
        }

        [ConfigurationProperty("VS9", IsRequired = true, IsKey = true)]
        public bool VS9
        {
            get { return (bool)this["VS9"]; }
            set { this["VS9"] = value; }
        }

        [ConfigurationProperty("VS10", IsRequired = true, IsKey = true)]
        public bool VS10
        {
            get { return (bool)this["VS10"]; }
            set { this["VS10"] = value; }
        }

        [ConfigurationProperty("ICPE", IsRequired = true, IsKey = true)]
        public bool ICPE
        {
            get { return (bool)this["ICPE"]; }
            set { this["ICPE"] = value; }
        }

        public override string MemberName
        {
            get { return this.ElementKey; }
        }
    }
}
