﻿using System.Text;
using System.Xml;
using CSSZSubmissionDemo.Settings;

namespace CSSZSubmissionDemo.Submissions
{
    class GovTalkResponse : SubmissionResponseBase
    {
        protected override string InternalDisplayName()
        {
            return "GovTalkResponse";
        }

        public void Initialize(ref byte[] content, SubmissionInfo info, Configuration.CertificateElement signerCert, Configuration.CertificateElement recipientCert)
        {
            this.content = content;
            this.info = null;
            this.signerCert = null;
            this.recipientCert = null;
        }

        protected byte[] data;

        public byte[] Decode(ref byte[] data, out AckInfo ack)
        {
            this.data = data;
            ack = new AckInfo() { ID = "", Class = "", internalID = "", status = "", function = "", qualifier = "", sigValid = false };

            XmlDocument doc = new XmlDocument();
            doc.PreserveWhitespace = true;
            doc.LoadXml(Encoding.UTF8.GetString(data));
            XmlNode nod = null;


            //correlationID
            nod = doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Header']/*[local-name()='MessageDetails']/*[local-name()='CorrelationID']");
            if (nod != null) ack.ID = nod.InnerText;
            //function submit, delete
            nod = doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Header']/*[local-name()='MessageDetails']/*[local-name()='Function']");
            if (nod != null) ack.function = nod.InnerText;
            //qualifier (request), ack, error, response
            nod = doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Header']/*[local-name()='MessageDetails']/*[local-name()='Qualifier']");
            if (nod != null) ack.qualifier = nod.InnerText;

            //error
            nod = doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='GovTalkDetails']/*[local-name()='GovTalkErrors']/*[local-name()='Error']/*[local-name()='Number']");
            if (nod != null) ack.errCode = nod.InnerText;
            nod = doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='GovTalkDetails']/*[local-name()='GovTalkErrors']/*[local-name()='Error']/*[local-name()='Text']");
            if (nod != null) ack.errTxt = nod.InnerText;

            //VREP Timestamp
            nod = doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Body']/*[local-name()='Signature' and namespace-uri()='http://www.w3.org/2000/09/xmldsig#']");
            if (nod != null)
            {
                //w3sig
                base.ValidateW3CSignature(ref nod);
            }
            nod = doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Body']/*[local-name()='Signature' and namespace-uri()='http://www.podani.gov.cz/TxE/timestamp']");
            if (nod != null)
            {
                //ggsig
                nod = nod.OwnerDocument.DocumentElement;
                base.ValidateGGSignature(ref nod);
            }

            //data
            XmlNode xCSSZMessage = doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Body']/*[local-name()='Message']");
            return DecodeCSSZMessage(ref ack, ref xCSSZMessage);
        }
    }
}
