﻿using System;
using System.Diagnostics;
using System.Security.Cryptography.X509Certificates;

namespace CSSZSubmissionDemo.Helpers
{
    public static class X509Certificate2Helpers
    {
        private static X509Certificate2 Select(Configuration.CertificateElement certSettings)
        {
            X509Certificate2 cert = null;
            Trace.WriteLine(String.Format("Loading certificate from store {0}/{1}", certSettings.StoreLocation, certSettings.StoreName));
            X509Store store = new X509Store(certSettings.StoreName, (StoreLocation)Enum.Parse(typeof(StoreLocation), certSettings.StoreLocation));
            store.Open(OpenFlags.ReadOnly);
            X509Certificate2Collection certs = X509Certificate2UI.SelectFromCollection(store.Certificates, "", "", X509SelectionFlag.SingleSelection);
            if (certs.Count == 1) cert = certs[0];
            store.Close();

            return cert;
        }

        public static X509Certificate2 Load(Configuration.CertificateElement certSettings)
        {
            X509Certificate2 cert = null;
            if (String.IsNullOrEmpty(certSettings.FilePath) == false)
            {
                Trace.WriteLine(String.Format("Loading certificate from {0}", certSettings.FilePath));
                if (!string.IsNullOrEmpty(certSettings.FilePassword))
                    cert = new X509Certificate2(certSettings.FilePath, certSettings.FilePassword);
                else
                    cert = new X509Certificate2(certSettings.FilePath);

            }
            else if (String.IsNullOrEmpty(certSettings.SerialNumber) == false)
            {
                Trace.WriteLine(String.Format("Loading certificate from store {0}/{1}: SN={2}", certSettings.StoreLocation, certSettings.StoreName, certSettings.SerialNumber));
                X509Store store = new X509Store(certSettings.StoreName, (StoreLocation)Enum.Parse(typeof(StoreLocation), certSettings.StoreLocation));
                store.Open(OpenFlags.ReadOnly);
                X509Certificate2Collection certs = store.Certificates;
                Trace.WriteLine(String.Format("Found {0} certs", certs.Count));
                if (certs.Count > 0)
                {
                    Trace.WriteLine(String.Format("Filtering by SN {0}", certSettings.SerialNumber));
                    certs = certs.Find(X509FindType.FindBySerialNumber, certSettings.SerialNumber, true);
                    Trace.WriteLine(String.Format("Found {0} certs", certs.Count));
                    if (certs.Count > 1)
                    {
                        if (string.IsNullOrEmpty(certSettings.Issuer) == false)
                        {
                            Trace.WriteLine(String.Format("Filtering by issuer {0}", certSettings.Issuer));
                            certs = certs.Find(X509FindType.FindByIssuerName, certSettings.Issuer, true);
                            Trace.WriteLine(String.Format("Found {0} certs", certs.Count));
                        }

                    }
                }
                if (certs.Count == 1) cert = certs[0];
                store.Close();
            }

            if (cert == null)
            {
                cert = Select(certSettings);
            }

            return cert;
        }
    }
}
