﻿using System;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;

namespace CSSZSubmissionDemo.Helpers
{
    public class SoapMessageListener : IEndpointBehavior, IClientMessageInspector
    {
        public string LastRequest { get; private set; }
        public string LastResponse { get; private set; }

        public void AfterReceiveReply(ref Message reply, object correlationState)
        {
            MessageBuffer buffer = reply.CreateBufferedCopy(Int32.MaxValue);
            string msgText = buffer.CreateMessage().ToString();
            LastResponse = msgText;
            reply = buffer.CreateMessage();
        }

        public object BeforeSendRequest(ref Message request, IClientChannel channel)
        {
            MessageBuffer buffer = request.CreateBufferedCopy(Int32.MaxValue);
            string msgText = buffer.CreateMessage().ToString();
            LastRequest = msgText;
            request = buffer.CreateMessage();
            return null;
        }

        public void ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime)
        {
            clientRuntime.MessageInspectors.Add(this);
        }

        public void AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters)
        {
        }

        public void ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher)
        {
        }

        public void Validate(ServiceEndpoint endpoint)
        {
        }

        public void Reset()
        {
            LastRequest = null;
            LastResponse = null;
        }
    }
}
