﻿using System.Configuration;

namespace CSSZSubmissionDemo.Configuration
{
    public class SubmissionDemoConfiguration : ConfigurationSection
    {
        public SubmissionDemoConfiguration() { }

        [ConfigurationProperty("EncryptionCertificate")]
        public CertificateElement EncryptionCertificate
        {
            get { return (CertificateElement)this["EncryptionCertificate"]; }
            set { this["EncryptionCertificate"] = value; }
        }

        [ConfigurationProperty("SigningCertificate")]
        public CertificateElement SigningCertificate
        {
            get { return (CertificateElement)this["SigningCertificate"]; }
            set { this["SigningCertificate"] = value; }
        }

        [ConfigurationProperty("Samples")]
        public PathElement SamplesPath
        {
            get { return (PathElement)this["Samples"]; }
            set { this["Samples"] = value; }
        }

        [ConfigurationProperty("Templates")]
        public PathElement TemplatesPath
        {
            get { return (PathElement)this["Templates"]; }
            set { this["Templates"] = value; }
        }

        [ConfigurationProperty("Submissions")]
        public PathElement SubmissionsPath
        {
            get { return (PathElement)this["Submissions"]; }
            set { this["Submissions"] = value; }
        }

        [ConfigurationProperty("Schemas")]
        public PathElement SchemasPath
        {
            get { return (PathElement)this["Schemas"]; }
            set { this["Schemas"] = value; }
        }


        [ConfigurationProperty("Identifiers", IsDefaultCollection = false)]
        [ConfigurationCollection(typeof(IdentifierElements))]
        public IdentifierElements Identifiers
        {
            get { return (IdentifierElements)base["Identifiers"]; }
        }

        [ConfigurationProperty("SubmissionTypes", IsDefaultCollection = true)]
        [ConfigurationCollection(typeof(GenericConfigurationCollection<SubmissionElement>))]
        public GenericConfigurationCollection<SubmissionElement> SubmissionTypes
        {
            get { return (GenericConfigurationCollection<SubmissionElement>)base["SubmissionTypes"]; }
        }


        [ConfigurationProperty("ISDSChannels", IsDefaultCollection = false)]
        [ConfigurationCollection(typeof(GenericConfigurationCollection<ISDSChannelElement>))]
        public GenericConfigurationCollection<ISDSChannelElement> ISDSChannels
        {
            get { return (GenericConfigurationCollection<ISDSChannelElement>)base["ISDSChannels"]; }
        }

        [ConfigurationProperty("VREPChannels", IsDefaultCollection = false)]
        [ConfigurationCollection(typeof(GenericConfigurationCollection<VREPChannelElement>))]
        public GenericConfigurationCollection<VREPChannelElement> VREPChannels
        {
            get { return (GenericConfigurationCollection<VREPChannelElement>)base["VREPChannels"]; }
        }

        [ConfigurationProperty("VREPWSChannels", IsDefaultCollection = false)]
        [ConfigurationCollection(typeof(GenericConfigurationCollection<VREPWSChannelElement>))]
        public GenericConfigurationCollection<VREPWSChannelElement> VREPWSChannels
        {
            get { return (GenericConfigurationCollection<VREPWSChannelElement>)base["VREPWSChannels"]; }
        }

        public static SubmissionDemoConfiguration Configuration
        {
            get { return (SubmissionDemoConfiguration)ConfigurationManager.GetSection("SubmissionDemoConfiguration"); }
        }
    }
}