﻿using System.Configuration;

namespace CSSZSubmissionDemo.Configuration
{

    [ConfigurationCollection(typeof(CustomConfigurationElementBase), CollectionType = ConfigurationElementCollectionType.BasicMap)]
    public class GenericConfigurationCollection<T> : ConfigurationElementCollection where T : CustomConfigurationElementBase, new()
    {
        protected override string ElementName
        {
            get { return "Item"; }
        }

        public override ConfigurationElementCollectionType CollectionType
        {
            get { return ConfigurationElementCollectionType.BasicMap; }
        }

        public T this[int index]
        {

            get
            {
                return base.BaseGet(index) as T;
            }

            set
            {
                if (base.BaseGet(index) != null)
                    base.BaseRemoveAt(index);

                base.BaseAdd(index, value);
            }

        }

        protected override ConfigurationElement CreateNewElement()
        {
            return new T();
        }

        protected override object GetElementKey(ConfigurationElement element)
        {
            return ((T)element).ElementKey;
        }

        new public T this[string id]
        {
            get { return (T)BaseGet(id); }
        }

        public int IndexOf(T element)
        {
            return BaseIndexOf(element);
        }

        public void Add(T element)
        {
            BaseAdd(element);
        }

        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        public void Remove(T element)
        {
            if (BaseIndexOf(element) >= 0)
                BaseRemove(element.ElementKey);
        }

        public void RemoveAt(int index)
        {
            BaseRemoveAt(index);
        }

        public void Remove(string find)
        {
            BaseRemove(find);
        }

        public void Clear()
        {
            BaseClear();
        }
    }
}


