﻿using System.Configuration;

namespace CSSZSubmissionDemo.Configuration
{
    public class IdentifierElement : ConfigurationElement
    {
        public IdentifierElement() { }

        public string DisplayName
        {
            get { return string.Format("{0} ({1})", Value, Type); }
        }

        [ConfigurationProperty("value", IsRequired = true)]
        public string Value
        {
            get { return (string)this["value"]; }
            set { this["value"] = value; }
        }

        [ConfigurationProperty("type", IsRequired = true)]
        public string Type
        {
            get { return (string)this["type"]; }
            set { this["type"] = value; }
        }

    }
}
