﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using CSSZSubmissionDemo.Configuration;
using CSSZSubmissionDemo.Helpers.Extensions;

namespace CSSZSubmissionDemo
{
    public partial class frmSubmission : Form
    {
        private byte[] buff = null;

        public frmSubmission(List<SubmissionElement> SubmissionTypes, List<ChannelElement> Channels, List<string> Formats, List<IdentifierElement> Identifiers, Dictionary<string, string> Samples)
        {
            InitializeComponent();
            cmbEtype.DataSource = SubmissionTypes;
            cmbEtype.DisplayMember = "DisplayName";
            cmbEtype.ValueMember = "MemberName";

            cmbChannel.DataSource = Channels;
            cmbChannel.DisplayMember = "DisplayName";
            cmbChannel.ValueMember = "MemberName";
            if (cmbChannel.Items != null && cmbChannel.Items.Count > 0)
            {
                ChannelElement ce = Channels.FirstOrDefault(c => c.Selected == true);
                if (ce != null)
                    cmbChannel.SelectedIndex = cmbChannel.FindString(ce.DisplayName);
            }

            cmbFormat.DataSource = Formats;

            cmbVS.DataSource = Identifiers;
            cmbVS.DisplayMember = "DisplayName";
            cmbVS.ValueMember = "Value";
            if (cmbVS.Items != null && cmbVS.Items.Count > 0) cmbVS.SelectedIndex = 0;

            cmbSamples.DataSource = new BindingSource(Samples, null);
            cmbSamples.DisplayMember = "Key";
            cmbSamples.ValueMember = "Value";
            cmbSamples.SelectionChangeCommitted += cmbSamples_SelectionChangeCommitted;
        }

        internal ChannelElement channel
        {
            get
            {
                return (ChannelElement)cmbChannel.SelectedItem;
            }
        }

        internal Submissions.SubmissionBase submission
        {
            get
            {
                if (buff != null && cmbEtype.SelectedItem != null && cmbFormat.SelectedItem != null)
                {

                    Submissions.SubmissionBase submission = Submissions.SubmissionBase.CreateSubmission((string)cmbFormat.SelectedItem);
                    Configuration.SubmissionElement sube = (Configuration.SubmissionElement)cmbEtype.SelectedItem;

                    submission.Initialize(ref buff, new KeyValuePair<string, string>(((IdentifierElement)cmbVS.SelectedItem).Type, ((IdentifierElement)cmbVS.SelectedItem).Value),
                        sube,
                        SubmissionDemoConfiguration.Configuration.SigningCertificate,
                        SubmissionDemoConfiguration.Configuration.EncryptionCertificate);
                    return submission;
                }
                else
                {
                    return null;
                }
            }
        }

        private void cmdBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog()
            {
                Filter = "Submissions (*.xml)|*.xml",
                CheckFileExists = true,
                Multiselect = false,
                ShowReadOnly = false,
                SupportMultiDottedExtensions = true,
                InitialDirectory = SubmissionDemoConfiguration.Configuration.SamplesPath.Path,
                RestoreDirectory = true
            };

            DialogResult dr = ofd.ShowDialog(this);
            txtPath.Text = ofd.FileName;
            LoadFile(ofd.FileName);
        }

        private void LoadFile(string filePath)
        {
            if (Path.GetExtension(filePath).ToLower() == ".xml")
            {
                Trace.WriteLine(string.Format("Loading file {0}", filePath));
                using (FileStream fs = new FileStream(filePath, FileMode.Open, FileAccess.Read, FileShare.Read))
                {
                    using (StreamReader sr = new StreamReader(fs))
                    {
                        txtContent.Text = sr.ReadToEnd();
                    }
                }
            }
            else
            {
                Trace.WriteLine(string.Format("Skipped file {0}", filePath));
                buff = null;
                txtPath.Text = "";
            }
        }

        private void txtContent_DragDrop(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop))
            {
                string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
                txtPath.Text = files[0];
                LoadFile(files[0]);
            }
        }

        private void txtContent_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop)) e.Effect = DragDropEffects.Copy;
        }

        private void txtContent_TextChanged(object sender, EventArgs e)
        {
            if (txtContent.Text.Length > 0)
            {
                SubmissionElement s = Helpers.Helper.ResolveSubmissionByContent(txtContent.Text);
                if (s != null) cmbEtype.SelectedValue = s.MemberName;
            }
        }

        private void cmdSend_Click(object sender, EventArgs e)
        {
            if (txtContent.Text.Length > 0)
            {
                buff = Encoding.UTF8.GetBytes(txtContent.Text);
                this.DialogResult = DialogResult.OK;
            }
            else
            {
                this.DialogResult = DialogResult.Abort;
            }
        }

        private void cmdRnd_Click(object sender, EventArgs e)
        {
            XmlDocument doc = new XmlDocument();
            txtContent.Text = doc.Randomize(txtContent.Text);

        }

        private void cmbSamples_SelectionChangeCommitted(object sender, EventArgs e)
        {
            if (cmbSamples.SelectedValue != null)
                LoadFile((string)cmbSamples.SelectedValue);
        }
    }
}
