﻿using System;
using System.Diagnostics;
using System.IO;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Xml;
using CSSZSubmissionDemo.Helpers.Extensions;

namespace CSSZSubmissionDemo.Submissions
{
    class GovTalkSubmission : SubmissionBase
    {
        protected override string InternalDisplayName()
        {
            return "GovTalk";
        }

        public override byte[] Encode()
        {
            return CreateGovTalkMessage();
        }

        protected byte[] CreateCSSZMessage()
        {
            Trace.WriteLine("Sign body");
            X509Certificate2 sc = Helpers.X509Certificate2Helpers.Load(signerCert);
            byte[] contentSignature = base.Sign(ref this.content, ref sc);
            string signature = Convert.ToBase64String(contentSignature);

            Trace.WriteLine("Compress");
            byte[] compressedData = base.Compress(ref this.content);

            Trace.WriteLine("Encrypt compressed");
            X509Certificate2 rc = Helpers.X509Certificate2Helpers.Load(recipientCert);

            // Pridejte vlastni certifikaty, pokud chcete mit moznost rozsifrovavat originaly zaslanych podani.
            X509Certificate2[] rcs = new X509Certificate2[] { rc };
            byte[] encryptedData = base.Encrypt(ref compressedData, ref rcs);
            string encrypted = Convert.ToBase64String(encryptedData);


            XmlDocument doc = new XmlDocument();
            doc.LoadFromTemplate("CSSZMessageTemplate.xml");
            Trace.WriteLine("Set XML values");
            doc.SelectSingleNode("/*[local-name()='Message']/*[local-name()='Header']/*[local-name()='Signature']").InnerText = signature;
            doc.SelectSingleNode("/*[local-name()='Message']/*[local-name()='Body']").InnerText = encrypted;
            doc.SelectSingleNode("/*[local-name()='Message']").Attributes["eType"].Value = this.info.eType;

            string appName = System.Windows.Forms.Application.ProductName;
            if (string.IsNullOrWhiteSpace(appName) == true) appName = Path.GetFileNameWithoutExtension(System.Windows.Forms.Application.ExecutablePath);
            if (string.IsNullOrWhiteSpace(appName) == true) doc.SelectSingleNode("/*[local-name()='Message']/*[local-name()='Header']/*[local-name()='Vendor']").Attributes["productName"].Value = appName;
            string version = System.Windows.Forms.Application.ProductVersion;
            if (string.IsNullOrWhiteSpace(version) == true) doc.SelectSingleNode("/*[local-name()='Message']/*[local-name()='Header']/*[local-name()='Vendor']").Attributes["version"].Value = version;

            return Encoding.UTF8.GetBytes(doc.DocumentElement.OuterXml);
        }

        protected byte[] CreateGovTalkMessage()
        {
            Trace.WriteLine("Create CSSZ Message");
            byte[] msgCSSZ = CreateCSSZMessage();

            Trace.WriteLine("Load GovTalk Template");
            XmlDocument doc = new XmlDocument();
            doc.LoadFromTemplate("GovTalkMessageTemplate.xml");
            Trace.WriteLine("Set XML valuess");
            doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Header']/*[local-name()='MessageDetails']/*[local-name()='Class']").InnerText = this.info.ClassName;
            doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Header']/*[local-name()='MessageDetails']/*[local-name()='Qualifier']").InnerText = "request";
            doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Header']/*[local-name()='MessageDetails']/*[local-name()='Function']").InnerText = "submit";
            doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Header']/*[local-name()='MessageDetails']/*[local-name()='CorrelationID']").InnerText = "";
            doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='GovTalkDetails']/*[local-name()='Keys']/*[local-name()='Key' and @Type='vars']").InnerText = this.ID.Value;
            doc.SelectSingleNode("/*[local-name()='GovTalkMessage']/*[local-name()='Body']").InnerXml = Encoding.UTF8.GetString(msgCSSZ);

            return Encoding.UTF8.GetBytes(doc.OuterXml);
        }
    }
}
