﻿using System;
using System.Diagnostics;

namespace CSSZSubmissionDemo.Helpers
{
    [DebuggerStepThrough()]
    class ConsoleListener : TraceListener
    {
        public override void Write(string message)
        {
            this.WriteOut(message);
        }

        public override void WriteLine(string message)
        {
            this.WriteOut(message);
        }

        private void WriteOut(string text)
        {
            Console.WriteLine(String.Format("{0:HH:mm:ss.fff}\t{1}", DateTime.Now, text));
        }
    }
}
