﻿using System.Configuration;

namespace CSSZSubmissionDemo.Configuration
{
    public class ISDSChannelElement : ChannelElement
    {
        public ISDSChannelElement()
        {
            this.ChannelType = typeof(Channels.ISDSChannel);
        }

        [ConfigurationProperty("recipient", IsRequired = false)]
        public string Recipient
        {
            get { return (string)this["recipient"]; }
            set { this["recipient"] = value; }
        }

        [ConfigurationProperty("URISuffix", IsRequired = false)]
        public URISuffixElement URISuffix
        {
            get { return (URISuffixElement)this["URISuffix"]; }
            set { this["URISuffix"] = value; }
        }

        [ConfigurationProperty("URIBase", IsRequired = false)]
        public URIBaseElement URIBase
        {
            get { return (URIBaseElement)this["URIBase"]; }
            set { this["URIBase"] = value; }
        }
    }
}
