﻿using System;
using System.Diagnostics;

namespace CSSZSubmissionDemo.Helpers
{
    class Worker
    {
        public event EventHandler Sent;
        public event EventHandler Polled;
        public event EventHandler CloseRequested;

        protected virtual void OnSent(EventArgs e)
        {
            if (Sent != null)
            {
                Sent(this, e);
            }
        }

        protected virtual void OnPolled(EventArgs e)
        {
            if (Polled != null)
            {
                Polled(this, e);
            }
        }

        protected virtual void OnCloseRequested(EventArgs e)
        {
            if (CloseRequested != null)
            {
                CloseRequested(this, e);
            }
        }

        public Settings.SubmissionInfo submissionInfo;
        public Submissions.SubmissionBase submission;
        public Channels.ChannelBase channel;

        public void SendSubmission(Object stateInfo)
        {
            Trace.WriteLine("Sending submission");
            channel.SendSubmission(submission);
            Trace.WriteLine("Submission sent");
            OnSent(new EventArgs());
        }

        public void PollResponse(Object stateInfo)
        {
            Trace.WriteLine("Polling submission");
            channel.PollForResponse(submissionInfo);
            Trace.WriteLine("Submission polled");
            OnPolled(new EventArgs());
        }

        public void AddSubmissionData(string InternalId, ref byte[] Data, string DataId)
        {
            Trace.WriteLine("Adding submission data");
            DAL.Connection.AddSubmissionData(InternalId, Data, DataId);
            Trace.WriteLine("Submission data added");
        }

        public void UpdateSubmissionStatus(string internalID, DAL.SubmissionStatus status)
        {
            Trace.WriteLine("Setting submission status");
            DAL.Connection.SetStatus(internalID, status);
            Trace.WriteLine("Submission status set");
        }

        public void CloseTransaction(Object stateInfo)
        {
            Trace.WriteLine("Closing transactions");
            channel.CompleteTransaction(submissionInfo);
            Trace.WriteLine("Close sent");
            OnCloseRequested(new EventArgs());
        }

        internal void SaveSubmission(DAL.SubmissionRecord submissionRecord)
        {
            Trace.WriteLine("Saving submission");
            DAL.Connection.AddSubmission(submissionRecord);
            Trace.WriteLine("Submission saved");
        }
    }
}
