﻿using System;
using System.Configuration;

namespace CSSZSubmissionDemo.Configuration
{

    [ConfigurationCollection(typeof(IdentifierElement), CollectionType = ConfigurationElementCollectionType.BasicMap)]
    public class IdentifierElements : ConfigurationElementCollection
    {
        protected override string ElementName
        {
            get { return "Identifier"; }
        }

        public override ConfigurationElementCollectionType CollectionType
        {
            get { return ConfigurationElementCollectionType.BasicMap; }
        }

        protected override ConfigurationElement CreateNewElement()
        {
            return new IdentifierElement();
        }

        protected override Object GetElementKey(ConfigurationElement element)
        {
            return String.Format("{0}#{1}", ((IdentifierElement)element).Value, ((IdentifierElement)element).Type);
        }

        public IdentifierElement this[int index]
        {
            get { return (IdentifierElement)BaseGet(index); }

            set
            {
                if (BaseGet(index) != null)
                    BaseRemoveAt(index);

                BaseAdd(index, value);
            }
        }

        new public IdentifierElement this[string id]
        {
            get { return (IdentifierElement)BaseGet(id); }
        }

        public int IndexOf(IdentifierElement element)
        {
            return BaseIndexOf(element);
        }

        public void Add(IdentifierElement element)
        {
            BaseAdd(element);
        }

        protected override void BaseAdd(ConfigurationElement element)
        {
            BaseAdd(element, false);
        }

        public void Remove(IdentifierElement element)
        {
            if (BaseIndexOf(element) >= 0)
                BaseRemove(element);
        }

        public void RemoveAt(int index)
        {
            BaseRemoveAt(index);
        }

        public void Remove(string find)
        {
            BaseRemove(find);
        }

        public void Clear()
        {
            BaseClear();
        }
    }
}
