﻿using System;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;
using CSSZSubmissionDemo.Configuration;

namespace CSSZSubmissionDemo.Helpers.Extensions
{
    public static class XmlDocumentExtensions
    {
        internal static XmlDocument LoadFromTemplate(this XmlDocument x, string templateName)
        {
            string tPath = Path.Combine(SubmissionDemoConfiguration.Configuration.TemplatesPath.Path, templateName);
            Trace.WriteLine(String.Format("Loading template {0}", tPath));
            x.Load(tPath);
            return x;
        }

        internal static string FormattedXml(this XmlDocument doc, string xml)
        {
            var sb = new StringBuilder();
            var settings = new XmlWriterSettings { Indent = true, IndentChars = @"    ", NewLineChars = Environment.NewLine, NewLineHandling = NewLineHandling.Replace, OmitXmlDeclaration = true };

            try
            {
                doc.LoadXml(xml);
                using (var writer = XmlWriter.Create(sb, settings))
                {
                    if (doc.ChildNodes[0] is XmlProcessingInstruction)
                    {
                        doc.RemoveChild(doc.ChildNodes[0]);
                    }

                    doc.Save(writer);
                    return sb.ToString();
                }
            }
            catch (Exception ex)
            {
                Trace.Write(String.Format("Error when trying to format xml: {0}", ex.ToString()));
                return "";
            }
        }

        internal static string Randomize(this XmlDocument doc, string content)
        {
            try
            {
                doc.PreserveWhitespace = true;
                doc.LoadXml(content);
                doc.DocumentElement.PrependChild(doc.CreateComment(Guid.NewGuid().ToString("N")));
                return doc.OuterXml;
            }
            catch (Exception ex)
            {
                Trace.WriteLine(string.Format("Exception while loading xml: {0}", ex.ToString()));
            }

            return content;
        }
    }
}
