﻿using System;
using System.Diagnostics;
using System.IO;
using System.Xml;
using CSSZSubmissionDemo.Configuration;

namespace CSSZSubmissionDemo.Helpers
{
    public class Helper
    {
        public static SubmissionElement ResolveSubmissionByFilename(string filePath)
        {
            string fn = Path.GetFileName(filePath);
            foreach (SubmissionElement s in SubmissionDemoConfiguration.Configuration.SubmissionTypes)
            {
                if (fn.ToLower().Contains((s.eType + ".").ToLower()) == true)
                {
                    return s;
                }
            }
            return null;
        }

        public static SubmissionElement ResolveSubmissionByContent(string content)
        {
            Trace.WriteLine(string.Format("Probing"));
            string root = "";
            string ns = "";

            XmlDocument doc = new XmlDocument();
            try
            {
                doc.LoadXml(content);
                root = doc.DocumentElement.LocalName;
                ns = doc.DocumentElement.NamespaceURI;
            }
            catch (Exception ex)
            {
                Trace.WriteLine(string.Format("Exception while probing: {0}", ex.ToString()));
            }

            if (string.IsNullOrEmpty(root) == false)
            {
                Trace.WriteLine(string.Format("Probing classname for {0}#{1}", root, ns));
                foreach (SubmissionElement s in SubmissionDemoConfiguration.Configuration.SubmissionTypes)
                {
                    if (s.XMLRoolElement == root && s.XMLNamespace == ns)
                    {
                        return s;
                    }
                }
            }

            return null;
        }
    }
}
