﻿using System;
using System.Text;

namespace CSSZSubmissionDemo.Settings
{
    [Serializable]
    public class SubmissionInfo
    {
        public string XMLRoolElement;
        public string XMLNamespace;
        public string ClassName;
        public string eType;
        public string ID;
        public string internalID;
        public string VS;
        public string DisplayName { get { return String.Format("{0} ({1})", this.ClassName, this.eType); } }
        public string MemberName { get { return String.Format("{0}|{1}", this.ClassName, this.eType); } }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            if (string.IsNullOrWhiteSpace(ClassName) == false) sb.Append(ClassName);
            if (string.IsNullOrWhiteSpace(ID) == false) sb.Append("/" + ID);
            if (string.IsNullOrWhiteSpace(internalID) == false) sb.Append("[" + internalID + "]");

            return sb.ToString();
        }

        public int[] vslengths;
    }

    [Serializable]
    public class AckInfo
    {
        public string ID;
        public string Class;
        public string VS;
        public string internalID;
        public string status;
        public string function;
        public string qualifier;
        public string errCode;
        public string errTxt;
        public string sigDate;
        public string sigTime;
        public bool sigValid;
    }
}
