
$requestBody = @"
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:urn="urn:cz:isvs:cssz:schemas:IkreDpnSpravaIcpe:v1" xmlns:urn1="urn:cz:isvs:cssz:schemas:IkreDpnMessages:v1" xmlns:urn2="urn:cz:isvs:cssz:schemas:IkrMessageTypes:v1">
   <soapenv:Header/>
   <soapenv:Body>
      <urn:IkreDpnVratIcpe verzeSluzby="1.0.0">
         <urn1:PozadavekHlavicka>
            <urn1:KodSluzby>IkreDpnVratIcpe</urn1:KodSluzby>
            <urn1:PozadavekInfo>
               <urn2:Cas>2019-01-01T12:00:00.000+01:00</urn2:Cas>
               <urn2:Popis>IkreDpnVratIcpe</urn2:Popis>
               <urn2:VstupniKanalId>B2B</urn2:VstupniKanalId>
               <urn2:PozadovanyVystupniKanalId>B2B</urn2:PozadovanyVystupniKanalId>
            </urn1:PozadavekInfo>
            <urn1:KlientInfo>
               <urn2:TypKlienta>PZS</urn2:TypKlienta>
               <urn2:KlientId>$env:ICO</urn2:KlientId>
               <urn2:JmenoUzivatele>Tester</urn2:JmenoUzivatele>
               <urn2:OrganizaceInfo>
                  <urn2:NazevOrganizace>Nemocnice</urn2:NazevOrganizace>
                  <urn2:ICO>$env:ICO</urn2:ICO>
               </urn2:OrganizaceInfo>
            </urn1:KlientInfo>
         </urn1:PozadavekHlavicka>
         <urn:PozadavekData>
            <urn:IcoPzs>$env:ICO</urn:IcoPzs>
         </urn:PozadavekData>
      </urn:IkreDpnVratIcpe>
   </soapenv:Body>
</soapenv:Envelope>
"@

$requestBody > $env:REQUEST

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
try {
    $R = Invoke-WebRequest -Uri $env:B2B_URL -CertificateThumbprint $env:CERTIFICATE_THUMBPRINT -Method POST -ContentType "text/xml" -Body $requestBody -OutFile $env:RESPONSE
}
catch {
    $_.Exception
    $result = $_.Exception.Response.GetResponseStream()
    $reader = New-Object System.IO.StreamReader($result)
    $reader.BaseStream.Position = 0
    $reader.DiscardBufferedData()
    $responseBody = $reader.ReadToEnd();
    $responseBody > $env:RESPONSE
}

